/*
+---------------------------------------------------------+
| Frances Ruiz and Michael J. Ruiz                        |
+---------------------------------------------------------|
| License:                                                |
| Creative Commons Attribution-NonCommerial 4.0 Unported  |
| http://creativecommons.org/licenses/by-nc/4.0/legalcode |
+---------------------------------------------------------+
| You are free to:                                        |
|                                                         |
| Share  copy and redistribute the material in any       |
|         medium or format                                |
| Adapt  remix, transform, and build upon the material   |
|                                                         |
| The licensor cannot revoke these freedoms as long as    |
| you follow the license terms.                           |
|                                                         |
| Attribution  You must give appropriate credit, include |
| this license, and indicate if changes were made. You    |
| may do so in any reasonable manner, but not in any way  |
| that suggests the licensor endorses you or your use.    |
|                                                         |
| Sample Credit Line: Courtesy Frances and Michael Ruiz   |
|                                                         |
| NonCommercial  You may not use the material for        |
|   commercial purposes.                                  |
|                                                         |
| No additional restrictions  You may not apply legal    |
| terms or technological measures that legally restrict   |
| others from doing anything the license permits.         |
+---------------------------------------------------------+
*/

function init () {
	//Grab all triangles and put in array of triangles in the following
	//order by class: b g r y m c (since this follows order of sliders and
	//slider_value text fields in the html and we are going to make use of
	//parallel arrays. Triangles can and will appear multiple times since many
	//triangles have multiple classes.
	var triangles = [document.getElementsByClassName("b"),
					document.getElementsByClassName("g"),
					document.getElementsByClassName("r"),
					document.getElementsByClassName("y"),
					document.getElementsByClassName("m"),
					document.getElementsByClassName("c")];
	
	//Make array of color strings for our parallel arrays
	var colors = ["b", "g", "r", "y", "m", "c"]; //blue green red yellow magenta cyan
	
	//Grab all sliders and slider_value text field elements
	var sliders = Array.prototype.slice.call( document.getElementsByClassName("slider") );
	var sliderFields = Array.prototype.slice.call( document.getElementsByClassName("slider_value") );
	
	//Add event listeners for sliders and slider_value text fields
	for (i = 0; i < sliders.length; i++) {
		sliders[i].addEventListener("input", sliderHandler);
		sliderFields[i].addEventListener("change", fieldHandler);
		//Next two for IE...triggering double events in other browsers but performance OK for now
		sliders[i].addEventListener("change", sliderHandler);
		sliderFields[i].addEventListener("keypress", fieldHandler);
	}
	
	//function that updates contents of text fields to match new slider value
	//and updates colors by calling updateColor function
	function updateFieldToSlider (slider) {
		var index = sliders.indexOf(slider);
		if (index != -1) {
			sliderFields[index].value = slider.value;
			updateColor(triangles[index], colors[index], slider.value);
		}
	}

	//updateSliderToField updates slider value to match new text field value
	//and updates colors by calling updateColor function
	function updateSliderToField (field) {
		//Validate the field value
		var fieldVal = field.value;
		if (isNaN(fieldVal)) {
			field.value = "0";
		}
		else {
			fieldVal = parseInt(field.value);
			if (fieldVal > 255) {
				field.value = "255";
			}
			else if (fieldVal < 0) {
				field.value = "0";
			}
			else if (! (fieldVal === field.value) ) { //not an integer number
				field.value = fieldVal;
			}
		}		
		//Find and update corresponding slider and update triangle colors
		var colorSlider;
		var index = sliderFields.indexOf(field);
		if (index != -1) {
			sliders[index].value = field.value;
			updateColor(triangles[index], colors[index], field.value);
		}
	}

	//sliderHandler is triggered by events on slider elements
	//calls the updateFieldToSlider function on the relevant slider
	function sliderHandler() {
		updateFieldToSlider(this);
	}
	
	//fieldHandler is triggered by events on field elements
	//if keypress, checks for enter key. calls updateSliderToField on
	//the relevant field
	function fieldHandler () {
		if (event.type == "keypress") {
			if (event.keyCode == 13) {
				updateSliderToField(this);
			}
			return;
		}
		else {
			updateSliderToField(this);
		}
	}

	//updateColor updates colors of triangles
	//takes which rgbcym color component being changed, and the new
	//strength for that color on a scale of 0 to 255
	function updateColor (triangles, color, strength) {
		strength = parseInt(strength); //safely a number here between 0 and 255
		//initialize some variables we are going to refill later
		var curColor = "#000000";
		var rStr = "00";
		var gStr = "00";
		var bStr = "00";
		var rVal = 0;
		var gVal = 0;
		var bVal = 0;
		//update color for each triangle that was passed in
		for (i = 0; i < triangles.length; i++) {
			curColor = triangles[i].getAttribute("fill");
			//pull out current r, g, b values from the hex
			rVal = parseInt(curColor.substring(1,3),16);
			gVal = parseInt(curColor.substring(3,5),16);
			bVal = parseInt(curColor.substring(5,7),16);
			//update the relevant r, g, or b value based on strength
			switch (color) {
				case "r":
					rVal = strength;
					break;
				case "g":
					gVal = strength;
					break;
				case "b":
					bVal = strength;
					break;
				case "c":
					rVal = 255 - strength;
					break;
				case "m":
					gVal = 255 - strength;
					break;
				case "y":
					bVal = 255 - strength;
					break;
			}
			//convert r, g, b ints back into strings then recombine to one long string
			rStr = rVal.toString(16);
			if (rStr.length == 1) {
				rStr = "0" + rStr;
			}
			gStr = gVal.toString(16);
			if (gStr.length == 1) {
				gStr = "0" + gStr;
			}
			bStr = bVal.toString(16);
			if (bStr.length == 1) {
				bStr = "0" + bStr;
			}
			curColor = "#" + rStr + gStr + bStr;
			//reset the triangle element colors
			triangles[i].setAttribute("fill", curColor);
			triangles[i].setAttribute("stroke", curColor);
		}
	}
}

window.onload = init;
