/*
+---------------------------------------------------------+
| Frances Ruiz and Michael J. Ruiz                        |
+---------------------------------------------------------|
| License:                                                |
| Creative Commons Attribution-NonCommerial 4.0 Unported  |
| http://creativecommons.org/licenses/by-nc/4.0/legalcode |
+---------------------------------------------------------+
| You are free to:                                        |
|                                                         |
| Share  copy and redistribute the material in any       |
|         medium or format                                |
| Adapt  remix, transform, and build upon the material   |
|                                                         |
| The licensor cannot revoke these freedoms as long as    |
| you follow the license terms.                           |
|                                                         |
| Attribution  You must give appropriate credit, include |
| this license, and indicate if changes were made. You    |
| may do so in any reasonable manner, but not in any way  |
| that suggests the licensor endorses you or your use.    |
|                                                         |
| Sample Credit Line: Courtesy Frances and Michael Ruiz   |
|                                                         |
| NonCommercial  You may not use the material for        |
|   commercial purposes.                                  |
|                                                         |
| No additional restrictions  You may not apply legal    |
| terms or technological measures that legally restrict   |
| others from doing anything the license permits.         |
+---------------------------------------------------------+
*/

//Slider Behavior specific to this implementation
RuizKit.Slider.prototype.onArrowDown = function () {
	updateColor(this);
}

RuizKit.Slider.prototype.onArrowUp = function () {
	updateColor(this);
}

RuizKit.Slider.prototype.onSliderDrag = function () {
	updateColor(this);
}

//bring in the document elements for this specific goal
var mySVG = document.getElementById("bit_scheme_svg"); 
var mainRect = document.getElementById("main_rect");
var blueRect = document.getElementById("blue_rect");
var greenRect = document.getElementById("green_rect");
var redRect = document.getElementById("red_rect");

var blueSlider = new RuizKit.Slider(mySVG, 20.5, 400.5, 4);
var greenSlider = new RuizKit.Slider(mySVG, 20.5, 350.5, 4);
var redSlider = new RuizKit.Slider(mySVG, 20.5, 300.5, 4);

//move blue slider to max value for visual interest
for (i = 0; i < blueSlider.rulerMarks.tickExes.length-1; i++) {
	blueSlider.moveSlider(1);
}
updateColor(blueSlider);

//updateColor updates colors of color rectangles based on
//a given slider's position. Also calls updateMainColor to
//update the color of the main rect as well
function updateColor (slider) {
	var sliderControlX = parseInt(slider.sliderControl.sliderControlLine.getAttribute("x1"));
	var curIndex = 0;// = slider.rulerMarks.curIndex;
	var minDist = 10000; //starter val too big for itself
	var dist = 10000;
	for (i = 0; i < slider.rulerMarks.tickExes.length; i++) {
		dist = Math.abs(slider.rulerMarks.tickExes[i] - sliderControlX);
		if (dist < minDist) {
			minDist = dist;
			curIndex = i;
		}
	}
	
	var strength = curIndex * 255/(slider.rulerMarks.tickExes.length - 1); //int no need to floor
	
	if (slider === blueSlider) {
		var rgbStr = "rgb(0, 0, " + strength.toString() + ")";
		blueRect.setAttribute("fill", rgbStr);
		updateMainColor("b", strength);
		return; 
	}
	if (slider === greenSlider) {
		var rgbStr = "rgb(0, " + strength.toString() + ", 0)";
		greenRect.setAttribute("fill", rgbStr);
		updateMainColor("g", strength);
		return;
	}
	if (slider === redSlider) {
		var rgbStr = "rgb(" + strength.toString() + " ,0, 0)";
		redRect.setAttribute("fill", rgbStr);
		updateMainColor("r", strength);
		return;
	}
}

//updateMainColor updates the main rect color
//one color channel updated at a time, so must pass in the color
//r, g, b and the strength from 0 to 255 of that color
function updateMainColor (color, strength) {
	strength = parseInt(strength); //safely a number here between 0 and 255
	//initialize some variables we are going to refill later
	var curColor = mainRect.getAttribute("fill");
	var rStr = "00";
	var gStr = "00";
	var bStr = "00";
	var rVal = 0;
	var gVal = 0;
	var bVal = 0;
	//pull out current r, g, b values from the hex
	rVal = parseInt(curColor.substring(1,3),16);
	gVal = parseInt(curColor.substring(3,5),16);
	bVal = parseInt(curColor.substring(5,7),16);
	//update the relevant r, g, or b value based on strength
	switch (color) {
		case "r":
			rVal = strength;
			break;
		case "g":
			gVal = strength;
			break;
		case "b":
			bVal = strength;
			break;
	}
	//convert r, g, b ints back into strings then recombine to one long string
	rStr = rVal.toString(16);
	if (rStr.length == 1) {
		rStr = "0" + rStr;
	}
	gStr = gVal.toString(16);
	if (gStr.length == 1) {
		gStr = "0" + gStr;
	}
	bStr = bVal.toString(16);
	if (bStr.length == 1) {
		bStr = "0" + bStr;
	}
	curColor = "#" + rStr + gStr + bStr;
	//reset the main rect color
	mainRect.setAttribute("fill", curColor);
}
