/*
+---------------------------------------------------------+
| Frances Ruiz and Michael J. Ruiz                        |
+---------------------------------------------------------|
| License:                                                |
| Creative Commons Attribution-NonCommerial 4.0 Unported  |
| http://creativecommons.org/licenses/by-nc/4.0/legalcode |
+---------------------------------------------------------+
| You are free to:                                        |
|                                                         |
| Share  copy and redistribute the material in any       |
|         medium or format                                |
| Adapt  remix, transform, and build upon the material   |
|                                                         |
| The licensor cannot revoke these freedoms as long as    |
| you follow the license terms.                           |
|                                                         |
| Attribution  You must give appropriate credit, include |
| this license, and indicate if changes were made. You    |
| may do so in any reasonable manner, but not in any way  |
| that suggests the licensor endorses you or your use.    |
|                                                         |
| Sample Credit Line: Courtesy Frances and Michael Ruiz   |
|                                                         |
| NonCommercial  You may not use the material for        |
|   commercial purposes.                                  |
|                                                         |
| No additional restrictions  You may not apply legal    |
| terms or technological measures that legally restrict   |
| others from doing anything the license permits.         |
+---------------------------------------------------------+
*/

function init() {
	//Set up the Addition Demo Object and Subtraction Demo Objects
	//that we will interact with
	addDemo = new RuizKit.AdditionDemo(document.getElementById("add_can"),
										50, 135, 36);
	subDemo = new RuizKit.SubtractionDemo(document.getElementById("sub_can"),
										15, 95, 70, 70);
	
	//Set up array for x11 color objects (name-hexStr pairs)
	var x11Colors = [
		{name:"Alice Blue", hexStr:"#F0F8FF"},
		{name:"Antique White", hexStr:"#FAEBD7"},
		{name:"Aqua", hexStr:"#00FFFF"},
		{name:"Aquamarine", hexStr:"#7FFFD4"},
		{name:"Azure", hexStr:"#F0FFFF"},
		{name:"Beige", hexStr:"#F5F5DC"},
		{name:"Bisque", hexStr:"#FFE4C4"},
		{name:"Black", hexStr:"#000000"},
		{name:"Blanched Almond", hexStr:"#FFEBCD"},
		{name:"Blue", hexStr:"#0000FF"},
		{name:"Blue Violet", hexStr:"#8A2BE2"},
		{name:"Brown", hexStr:"#A52A2A"},
		{name:"Burlywood", hexStr:"#DEB887"},
		{name:"Cadet Blue", hexStr:"#5F9EA0"},
		{name:"Chartreuse", hexStr:"#7FFF00"},
		{name:"Chocolate", hexStr:"#D2691E"},
		{name:"Coral", hexStr:"#FF7F50"},
		{name:"Cornflower", hexStr:"#6495ED"},
		{name:"Cornsilk", hexStr:"#FFF8DC"},
		{name:"Crimson", hexStr:"#DC143C"},
		{name:"Cyan", hexStr:"#00FFFF"},
		{name:"Dark Blue", hexStr:"#00008B"},
		{name:"Dark Cyan", hexStr:"#008B8B"},
		{name:"Dark Goldenrod", hexStr:"#B8860B"},
		{name:"Dark Gray", hexStr:"#A9A9A9"},
		{name:"Dark Green", hexStr:"#006400"},
		{name:"Dark Khaki", hexStr:"#BDB76B"},
		{name:"Dark Magenta", hexStr:"#8B008B"},
		{name:"Dark Olive Green", hexStr:"#556B2F"},
		{name:"Dark Orange", hexStr:"#FF8C00"},
		{name:"Dark Orchid", hexStr:"#9932CC"},
		{name:"Dark Red", hexStr:"#8B0000"},
		{name:"Dark Salmon", hexStr:"#E9967A"},
		{name:"Dark Sea Green", hexStr:"#8FBC8F"},
		{name:"Dark Slate Blue", hexStr:"#483D8B"},
		{name:"Dark Slate Gray", hexStr:"#2F4F4F"},
		{name:"Dark Turquoise", hexStr:"#00CED1"},
		{name:"Dark Violet", hexStr:"#9400D3"},
		{name:"Deep Pink", hexStr:"#FF1493"},
		{name:"Deep Sky Blue", hexStr:"#00BFFF"},
		{name:"Dim Gray", hexStr:"#696969"},
		{name:"Dodger Blue", hexStr:"#1E90FF"},
		{name:"Firebrick", hexStr:"#B22222"},
		{name:"Floral White", hexStr:"#FFFAF0"},
		{name:"Forest Green", hexStr:"#228B22"},
		{name:"Fuchsia", hexStr:"#FF00FF"},
		{name:"Gainsboro", hexStr:"#DCDCDC"},
		{name:"Ghost White", hexStr:"#F8F8FF"},
		{name:"Gold", hexStr:"#FFD700"},
		{name:"Goldenrod", hexStr:"#DAA520"},
		{name:"Gray", hexStr:"#BEBEBE"},
		{name:"Web Gray", hexStr:"#808080"},
		{name:"Green", hexStr:"#00FF00"},
		{name:"Web Green", hexStr:"#008000"},
		{name:"Green Yellow", hexStr:"#ADFF2F"},
		{name:"Honeydew", hexStr:"#F0FFF0"},
		{name:"Hot Pink", hexStr:"#FF69B4"},
		{name:"Indian Red", hexStr:"#CD5C5C"},
		{name:"Indigo", hexStr:"#4B0082"},
		{name:"Ivory", hexStr:"#FFFFF0"},
		{name:"Khaki", hexStr:"#F0E68C"},
		{name:"Lavender", hexStr:"#E6E6FA"},
		{name:"Lavender Blush", hexStr:"#FFF0F5"},
		{name:"Lawn Green", hexStr:"#7CFC00"},
		{name:"Lemon Chiffon", hexStr:"#FFFACD"},
		{name:"Light Blue", hexStr:"#ADD8E6"},
		{name:"Light Coral", hexStr:"#F08080"},
		{name:"Light Cyan", hexStr:"#E0FFFF"},
		{name:"Light Goldenrod", hexStr:"#FAFAD2"},
		{name:"Light Gray", hexStr:"#D3D3D3"},
		{name:"Light Green", hexStr:"#90EE90"},
		{name:"Light Pink", hexStr:"#FFB6C1"},
		{name:"Light Salmon", hexStr:"#FFA07A"},
		{name:"Light Sea Green", hexStr:"#20B2AA"},
		{name:"Light Sky Blue", hexStr:"#87CEFA"},
		{name:"Light Slate Gray", hexStr:"#778899"},
		{name:"Light Steel Blue", hexStr:"#B0C4DE"},
		{name:"Light Yellow", hexStr:"#FFFFE0"},
		{name:"Lime", hexStr:"#00FF00"},
		{name:"Lime Green", hexStr:"#32CD32"},
		{name:"Linen", hexStr:"#FAF0E6"},
		{name:"Magenta", hexStr:"#FF00FF"},
		{name:"Maroon", hexStr:"#B03060"},
		{name:"Web Maroon", hexStr:"#7F0000"},
		{name:"Medium Aquamarine", hexStr:"#66CDAA"},
		{name:"Medium Blue", hexStr:"#0000CD"},
		{name:"Medium Orchid", hexStr:"#BA55D3"},
		{name:"Medium Purple", hexStr:"#9370DB"},
		{name:"Medium Sea Green", hexStr:"#3CB371"},
		{name:"Medium Slate Blue", hexStr:"#7B68EE"},
		{name:"Medium Spring Green", hexStr:"#00FA9A"},
		{name:"Medium Turquoise", hexStr:"#48D1CC"},
		{name:"Medium Violet Red", hexStr:"#C71585"},
		{name:"Midnight Blue", hexStr:"#191970"},
		{name:"Mint Cream", hexStr:"#F5FFFA"},
		{name:"Misty Rose", hexStr:"#FFE4E1"},
		{name:"Moccasin", hexStr:"#FFE4B5"},
		{name:"Navajo White", hexStr:"#FFDEAD"},
		{name:"Navy Blue", hexStr:"#000080"},
		{name:"Old Lace", hexStr:"#FDF5E6"},
		{name:"Olive", hexStr:"#808000"},
		{name:"Olive Drab", hexStr:"#6B8E23"},
		{name:"Orange", hexStr:"#FFA500"},
		{name:"Orange Red", hexStr:"#FF4500"},
		{name:"Orchid", hexStr:"#DA70D6"},
		{name:"Pale Goldenrod", hexStr:"#EEE8AA"},
		{name:"Pale Green", hexStr:"#98FB98"},
		{name:"Pale Turquoise", hexStr:"#AFEEEE"},
		{name:"Pale Violet Red", hexStr:"#DB7093"},
		{name:"Papaya Whip", hexStr:"#FFEFD5"},
		{name:"Peach Puff", hexStr:"#FFDAB9"},
		{name:"Peru", hexStr:"#CD853F"},
		{name:"Pink", hexStr:"#FFC0CB"},
		{name:"Plum", hexStr:"#DDA0DD"},
		{name:"Powder Blue", hexStr:"#B0E0E6"},
		{name:"Purple", hexStr:"#A020F0"},
		{name:"Web Purple", hexStr:"#7F007F"},
		{name:"Rebecca Purple", hexStr:"#663399"},
		{name:"Red", hexStr:"#FF0000"},
		{name:"Rosy Brown", hexStr:"#BC8F8F"},
		{name:"Royal Blue", hexStr:"#4169E1"},
		{name:"Saddle Brown", hexStr:"#8B4513"},
		{name:"Salmon", hexStr:"#FA8072"},
		{name:"Sandy Brown", hexStr:"#F4A460"},
		{name:"Sea Green", hexStr:"#2E8B57"},
		{name:"Seashell", hexStr:"#FFF5EE"},
		{name:"Sienna", hexStr:"#A0522D"},
		{name:"Silver", hexStr:"#C0C0C0"},
		{name:"Sky Blue", hexStr:"#87CEEB"},
		{name:"Slate Blue", hexStr:"#6A5ACD"},
		{name:"Slate Gray", hexStr:"#708090"},
		{name:"Snow", hexStr:"#FFFAFA"},
		{name:"Spring Green", hexStr:"#00FF7F"},
		{name:"Steel Blue", hexStr:"#4682B4"},
		{name:"Tan", hexStr:"#D2B48C"},
		{name:"Teal", hexStr:"#008080"},
		{name:"Thistle", hexStr:"#D8BFD8"},
		{name:"Tomato", hexStr:"#FF6347"},
		{name:"Turquoise", hexStr:"#40E0D0"},
		{name:"Violet", hexStr:"#EE82EE"},
		{name:"Wheat", hexStr:"#F5DEB3"},
		{name:"White", hexStr:"#FFFFFF"},
		{name:"White Smoke", hexStr:"#F5F5F5"},
		{name:"Yellow", hexStr:"#FFFF00"},
		{name:"Yellow Green", hexStr:"#9ACD32"}
	];

	//Create the select drop-down using information from
	//x11Colors array
	var demoDiv = document.getElementById("x11ColorSet");
	var x11Select = document.createElement("select");
	x11Select.id = "x11_select";
	x11Select.size = 12;
	demoDiv.appendChild(x11Select);

	for (i = 0; i < x11Colors.length; i++) {
		var option = document.createElement("option");
		option.value = x11Colors[i].name;
		option.text = x11Colors[i].name;
		x11Select.appendChild(option);
	}

	//Bring in document elements that are going to be manipulated
	var mainRect = document.getElementById("main_rect");
	var rRect = document.getElementById("r_rect");
	var gRect = document.getElementById("g_rect");
	var bRect = document.getElementById("b_rect");
	var cRect = document.getElementById("c_rect");
	var mRect = document.getElementById("m_rect");
	var yRect = document.getElementById("y_rect");
	var rectsArr = [rRect, gRect, bRect, cRect, mRect, yRect];
	var rValText = document.getElementById("r_val");
	var gValText = document.getElementById("g_val");
	var bValText = document.getElementById("b_val");
	var cValText = document.getElementById("c_val");
	var mValText = document.getElementById("m_val");
	var yValText = document.getElementById("y_val");
	var rHexText = document.getElementById("r_hex");
	var gHexText = document.getElementById("g_hex");
	var bHexText = document.getElementById("b_hex");

	//Initialize Rectangles
	updateColors();

	//Add Event Listener on x11Select element
	x11Select.addEventListener("input", updateColors);

	//updateColor updates colors of color rectangles based on
	//the selected color from the x11Select element
	//if no color is selected, defaults to white
	function updateColors () {	
		//find proper hex value for the selected color
		var index = x11Select.selectedIndex;
		var hexStr = "#FFFFFF";
		if (index != -1) {
			hexStr = x11Colors[index].hexStr;
		}
		//pull out current rgbcmy values from the hex
		var rVal = parseInt(hexStr.substring(1,3),16);
		var gVal = parseInt(hexStr.substring(3,5),16);
		var bVal = parseInt(hexStr.substring(5,7),16);
		var cVal = 255 - rVal;
		var mVal = 255 - gVal;
		var yVal = 255 - bVal;
		//update the text elements with rgbcmy information
		rValText.textContent = rVal;
		gValText.textContent = gVal;
		bValText.textContent = bVal;
		cValText.textContent = cVal;
		mValText.textContent = mVal;
		yValText.textContent = yVal;
		rHexText.textContent = hexStr.substring(1,3);
		gHexText.textContent = hexStr.substring(3,5);
		bHexText.textContent = hexStr.substring(5,7);
		//update the colors of the rect elements
		mainRect.setAttribute("fill", hexStr);
		rRect.setAttribute("fill", "#" + hexStr.substring(1,3) + "0000");
		gRect.setAttribute("fill", "#00" + hexStr.substring(3,5) + "00");
		bRect.setAttribute("fill", "#0000" + hexStr.substring(5,7));
		cRect.setAttribute("fill", "#" + hexStr.substring(1,3) + "FFFF");
		mRect.setAttribute("fill", "#FF" + hexStr.substring(3,5) + "FF");
		yRect.setAttribute("fill", "#FFFF" + hexStr.substring(5,7));
		//update heights of the rect elements
		updateHeights([rVal, gVal, bVal, cVal, mVal, yVal]);
		//update the colors of the addition and subtraction demos
		addDemo.updateCircleColors(rRect.getAttribute("fill"),
								   gRect.getAttribute("fill"),
								   bRect.getAttribute("fill"));
		subDemo.updateRectColors(cRect.getAttribute("fill"),
								 mRect.getAttribute("fill"),
								 yRect.getAttribute("fill"));
	}

	//updates the heights of the color rectangles so the heights are proportional
	//to the strengths of their respective rgbcmy color values
	//an array of the strengths of each color channel is passed in [r,g,b,c,m,y]
	//with values ranging from 0 to 255
	function updateHeights(colorValsArr) {
		var maxHeight = 79;
		var minY = 179.5;
		var stepSize = 79/255.0;
		for (var i = 0; i < colorValsArr.length; i++) {
			var newHeight = Math.round(stepSize * colorValsArr[i]) + 1;
			var newY = minY - newHeight;
			rectsArr[i].setAttribute("y", newY);
			rectsArr[i].setAttribute("height", newHeight);
		}
	}
}
window.onload = init;
